/*
 * Decompiled with CFR 0.152.
 */
package blueduck.jellyfishing.client.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SuitModel<T extends LivingEntity>
extends HumanoidModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("jellyfishing", "suit"), "main");
    public static final ResourceLocation TEXTURE_HELMET = new ResourceLocation("jellyfishing", "textures/models/armor/air_suit_helmet.png");
    public static final ResourceLocation TEXTURE_CHESTPLATE = new ResourceLocation("jellyfishing", "textures/models/armor/air_suit_chest.png");
    public static final ResourceLocation TEXTURE_LEGGINGS = new ResourceLocation("jellyfishing", "textures/models/armor/air_suit_legs.png");
    public static final ResourceLocation TEXTURE_BOOTS = new ResourceLocation("jellyfishing", "textures/models/armor/air_suit_boots.png");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private LivingEntity currentEntity;

    public SuitModel(ModelPart root) {
        super(root);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-6.0f, -11.0f, -5.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -13.0f, -6.0f, 6.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171488_(-3.2f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171488_(-0.6f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.1f)).m_171514_(34, 34).m_171488_(-3.0f, 9.0f, -4.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.1f)).m_171514_(34, 34).m_171488_(-2.0f, 9.0f, -4.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void setRotationAngle(ModelPart part, float x, float y, float z) {
        part.f_104203_ = x;
        part.f_104204_ = y;
        part.f_104205_ = z;
    }

    public void m_8009_(boolean visible) {
        this.head.f_104207_ = visible;
        this.f_102809_.f_104207_ = false;
        this.body.f_104207_ = visible;
        this.rightArm.f_104207_ = visible;
        this.leftArm.f_104207_ = visible;
        this.rightLeg.f_104207_ = visible;
        this.leftLeg.f_104207_ = visible;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.f_102809_.f_104207_ = false;
        super.m_7695_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void followBodyRotations(LivingEntity livingEntity, SuitModel model) {
        LivingEntityRenderer livingRenderer;
        EntityModel entityModel;
        EntityRenderer render = Minecraft.m_91087_().m_91290_().m_114382_((Entity)livingEntity);
        if (render instanceof LivingEntityRenderer && (entityModel = (livingRenderer = (LivingEntityRenderer)render).m_7200_()) instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)entityModel;
        }
    }

    public void copyFrom(ModelPart main, ModelPart transfer) {
        main.f_104203_ = transfer.f_104203_;
        main.f_104204_ = transfer.f_104204_;
        main.f_104205_ = transfer.f_104205_;
        main.f_104200_ = transfer.f_104200_ - 5.0f;
        main.f_104201_ = transfer.f_104201_ - 8.0f;
        main.f_104202_ = transfer.f_104202_ + 6.0f;
    }

    public void setCurrentEntity(LivingEntity entityLiving) {
        this.currentEntity = entityLiving;
    }
}

